% figures for the chapter Mechanical Ventilation

mm_=0.001;cm_=0.01;m_=1;
s_=1;ms_=0.001;min_=60;
kg_=1;g_=kg_/1000;
mbar_=100;
L_=0.001;mL_=L_/1000;lpm=L_/min_;lps=L_/s_;
eta=17E-6; kappa = 1.4;
R = 8.3145; M_luft = 29*g_;
rho0 = M_luft*1013*mbar_/(R * 293);
M=50;
freq=logspace(-2,3,M);
omega=2*pi*freq;
s=tf('s');
nfig = 0;
ReKrit = 2040;

if 1  %+++++++++++++++++++++++++++++++++++++++++++++++++Abkrzung 1

%------------------------------------------------
% Palv/Ppleura/Plung over Volume (lung/chest)
%------------------------------------------------
PV_chest_lung = [...
%P_ch   V_ch    P_lung  V_lung
-32.76	1.22	0.64	0.29
-30.13	1.29	2.64	1.22
-19.65	1.59	5.26	2.51
-9.16	2.10	9.85	3.90
-4.57	2.51	15.09	4.88
0.02	3.95	20.99	5.56
4.61	5.05	30.17	6.00
9.19	6.00     0      0
-36     1.22     0      0]; % Punkte entnommen www.acbrown.com/lung/Lectures/RsVntl/RsVntl42.gif
P_chest = PV_chest_lung(:,1);   % mbar
V_chest = PV_chest_lung(:,2);   % L
P_lung  = PV_chest_lung(1:7,3); % mbar
V_lung  = PV_chest_lung(1:7,4); % L
Poly_chest = polyfit(P_chest,V_chest,3);
Poly_lung  = polyfit(P_lung ,V_lung ,4);
Pch = -32.8:0.2:9.2;
Vpoly_chest = polyval(Poly_chest,Pch); % nicht brauchbar
Pl = 0.7:0.2:30;
Vpoly_lung  = polyval(Poly_lung ,Pl);
Ps = -40:0.2:40;
a = 1.2; b=5.07; c=10; d=10;
Vsig = a + b./(1+exp(-(Ps-c)/d)); % sigmoider Druckverlauf, Parameter ausprobiert
Vc = min(Vsig):0.01:6; Pch=zeros(length(Vc),1);
Pc0 = 100; %fr Nullsuche
for ic = 1:length(Vc) % Pc ber Vc durch Pc = Ps - Pl
    for i=2:length(Vsig)
        if Vsig(i) >= Vc(ic)
            Pc(ic) = Ps(i)-(Ps(i)-Ps(i-1))...
                *(Vsig(i)-Vc(ic))/(Vsig(i)-Vsig(i-1));
            break;
        end
    end
    for i=2:length(Vpoly_lung)
        if Vpoly_lung(i) >= Vc(ic)
            Pc(ic) = Pc(ic) +0.64 - Pl(i)+(Pl(i)-Pl(i-1))...
                *(Vpoly_lung(i)-Vc(ic))/(Vpoly_lung(i)-Vpoly_lung(i-1));
            break;
        end
    end
    if abs(Pc(ic)) < Pc0
        Pc0 = abs(Pc(ic));
        ic0 = ic;
    end
end
nfig=nfig+1;figure(nfig);clf;
axes('position', [0.083 0.12 0.5 0.8]); %[left, bottom, width, height]
fontsize = 11;
plot(Pl-0.64,Vpoly_lung,'k','LineWidth',2); hold on;
plot(Ps,Vsig,'k-','LineWidth',3); hold on;
plot(Pc,Vc,'k-','LineWidth',2); hold on;
%
%plot(P_chest,V_chest,'.'); hold on;
%plot(P_lung, V_lung, 'o'); hold on;
%
text(-1,5.5,'p_{Pleura}', 'FontSize', fontsize);
text(11,5.5,'p_{Lung}', 'FontSize', fontsize);
text(32,5.5,'p_{alv}', 'FontSize', fontsize);
Vmin = 0.29; 
RV   = a + b./(1+exp(-(-30-c)/d));
FRC  = a + b./(1+exp(-(0-c)/d));
TLC  = 6;
V=zeros(length(Ps),1); 
V(:)=Vmin;plot(Ps,V,'k:');hold on; %kleinstes Vlung
text(-29.5,V(1)+0.2,'Minimal lung volume', 'FontSize', fontsize);
V(:)=RV;plot(Ps,V,'k:');hold on; % RV
text(-29.5,V(1)+0.2,'RV', 'FontSize', fontsize);
V(:)=FRC;plot(Ps,V,'k:');hold on; % FRC
text(-29.5,V(1)+0.2,'FRC', 'FontSize', fontsize);
V(:)=Vc(ic0);plot(Ps,V,'k:');hold on; % Thorax-Ruhevolumen
text(-29.5,V(1)+0.2,'Thorax voume at rest', 'FontSize', fontsize);
V(:)=TLC;plot(Ps,V,'k:');hold on; % TLC
text(-29.5,V(1)-0.2,'TLC', 'FontSize', fontsize);
plot([0 0], [0 6],'k:'); % p = 0
xlim([-30 40]);
ylim([0 6.1]);
xlabel('Pressure / mbar', 'FontSize', fontsize);
ylabel('Volume / $\ell$', 'FontSize', fontsize, 'interpreter','latex');
%--- Magnification with Compliance
V5  = a + b./(1+exp(-( 5-c)/d)); %V(5mbar)
V15 = a + b./(1+exp(-(15-c)/d)); %V(15mbar)
% finde Pc, Pl von V5 und V15
for i=2:length(Vc) 
    if Vc(i) >= V5
        Pc_V5 = Pc(i)-(Pc(i)-Pc(i-1))...
            *(Vc(i)-V5)/(Vc(i)-Vc(i-1));
        break;
    end
end
for i=2:length(Vc)
    if Vc(i) >= V15
        Pc_V15 = Pc(i)-(Pc(i)-Pc(i-1))...
            *(Vc(i)-V15)/(Vc(i)-Vc(i-1));
        break;
    end
end
Vl = Vpoly_lung;
for i=2:length(Vl)
    if Vl(i) >= V5
        Pl_V5 = Pl(i)-0.64-(Pl(i)-Pl(i-1))...
            *(Vl(i)-V5)/(Vl(i)-Vl(i-1));
        break;
    end
end
for i=2:length(Vl)
    if Vl(i) >= V15
        Pl_V15 = Pl(i)-0.64-(Pl(i)-Pl(i-1))...
            *(Vl(i)-V15)/(Vl(i)-Vl(i-1));
        break;
    end
end
C_Lunge  = 1000*(V15-V5)/(Pl_V15-Pl_V5);
C_Thorax = 1000*(V15-V5)/(Pc_V15-Pc_V5);
C_rs     = 1/(1/C_Lunge + 1/C_Thorax);
if 1
    fprintf('C_Lunge %5.2f, C_Thorax %5.2f, C_rs %5.2f (mL/mbar)\n',...
        C_Lunge, C_Thorax, C_rs);
    fprintf('Min. Vol %5.3f, RV %5.3f, FRC %5.3f, TLC %5.3f\n',...
        Vmin, RV, FRC, TLC);        
end
axes('position', [0.65 0.12 0.3 0.8]); %[left, bottom, width, height]
plot(Pl-0.64,Vpoly_lung,'k','LineWidth',2); hold on;
plot(Ps,Vsig,'k-','LineWidth',3); hold on;
plot(Pc,Vc,'k-','LineWidth',2); hold on;
V(:)=0.29;plot(Ps,V,'k:');hold on; %kleinstes Vlung
V(:)=a + b./(1+exp(-(-30-c)/d));plot(Ps,V,'k:');hold on; % RV
V(:)=a + b./(1+exp(-(0-c)/d));plot(Ps,V,'k:');hold on; % FRC
V(:)=Vc(ic0);plot(Ps,V,'k:');hold on; % Thorax-Ruhevolumen
V(:)=6;plot(Ps,V,'k:');hold on; % TLC
%plot([0 0], [0 6],'k:'); % p = 0
plot([5 5], [0 V5],'k:'); % p = 5
plot([15 15], [0 V15],'k:'); % p = 15
plot([-10 15], [V5 V5],'k:','LineWidth',1);
plot([-10 15], [V15 V15],'k:','LineWidth',1);
plot([Pc_V5 Pc_V15], [V15 V15],'k--','LineWidth',2.4);
plot([Pl_V5 Pl_V15], [V15 V15],'k--','LineWidth',2.4);
plot([5 15], [V5 V5],'k--','LineWidth',2.4);
plot([15 15], [V5 V15],'k--','LineWidth',2.4);
text(10, V5-0.25, '\Deltap_{rs}', 'FontSize', fontsize);
text(15.6, (V5+V15)/2, '\DeltaV', 'FontSize', fontsize);
text(Pc_V5-2, V15+0.3, '\Deltap_{Thorax}', 'FontSize', fontsize);
text(Pl_V5-0.8, V15+0.3, '\Deltap_{Lung}', 'FontSize', fontsize);
xlim([-10 20]);
%------------------------------------------------
% Umschlagpunkt Laminar - Turbulent bei Re = ReKrit
%------------------------------------------------
nfig=nfig+1;figure(nfig);clf;
% Re = rho*w*D/eta, w = Flow/A, A = (pi/4)*D^2
D = (0:1:30)*1E-3;
Flow = (pi/4)*ReKrit*eta*D/rho0;
plot(D/mm_,Flow/(L_/s_),'k','LineWidth',1);
grid on;
title(sprintf('Re > %d --> turbulent pipe flow. Air, 20C, 1013mbar',cast(ReKrit,'int32')));
xlabel('Diameter d / mm');
%ylabel('{\bf $$\dot V$$}','Interpreter','latex');
ylabel('$\dot{\mbox{V}}$ / ($\ell$/s)','interpreter','latex');
text(21,0.35,'laminar','fontweight','n', 'FontSize', fontsize);
text(5.5,0.35,'turbulent','fontweight','n', 'FontSize', fontsize);
% Rohrreibungszahl Lambda bei turbulenter Rohrstrmung
Lambda = 0.3164 * ReKrit^(-0.25);
%------------------------------------------------
% K1, K2-Nherung
%------------------------------------------------
disp('---------------');
disp('K1, K2-Nherung');
nfig=nfig+1;figure(nfig);clf;
clear D, clear L, clear F;
D(1)=2.5*mm_;L(1)=12*cm_;
D(2)=5*mm_;L(2)=24*cm_;
D(3)=9*mm_;L(3)=150*cm_;
D(4)=15*mm_;L(4)=150*cm_;
F=(1:2000)*lpm/10;

Fref = 4*(L_/s_);
Lref = 1*m_;
Dref = 10*mm_;
K1_75ref = 0.3164*eta^0.25*(Lref/Dref^4.75)*(4*2^0.5/pi^1.75)*rho0^0.75;
dPfix = K1_75ref*Fref^1.75; %250L/min->38.8,4L/s->35.9
disp(sprintf('Dref %4.1f mm, Lref %4.0f cm, Fref %6.2f l/min, dPfix %6.2f mbar',...
    Dref/mm_, Lref/cm_, Fref/(L_/min_), dPfix/mbar_));
for i=1:4
    K1R(i) = 0.693*mbar_/(L_/s_)*(10*mm_/D(i))^4*(L(i)/m_);
    Ffix = ((L(i)/m_)^-0.571)*((D(i)/(10*mm_))^2.714)*Fref;
    K2(i) = ((dPfix/Ffix) - K1R(i)) / Ffix;
    for j=1:length(F)
        dpR(i,j)=K1R(i)*F(j)+K2(i)*F(j)^2;
    end
    disp(sprintf('D %4.1f mm, L %3.0f cm, K1 %5.2f mbar/(l/s), Ffix %6.2f l/min, K2 %6.2f mbar/(l/s)^2',...
        D(i)/mm_, L(i)/cm_, K1R(i)/(mbar_/(L_/s_)), Ffix/(L_/min_), K2(i)/(mbar_/(L_/s_)^2)));
end

%------------------------------------------------
% Druck ber Schlauch
%------------------------------------------------
for i=1:4
    K1(i) = 128*eta*L(i)/(pi*D(i)^4);
    K1_75(i) = 0.3164*eta^0.25*(L(i)/D(i)^4.75)*(4*2^0.5/pi^1.75)*rho0^0.75;
    Fkrit(i) = (pi/4)*ReKrit*eta*D(i)/rho0;
    Sprung(i) = K1_75(i)*Fkrit(i)^1.75/(K1(i)*Fkrit(i));
    for j=1:length(F)
        if F(j) < Fkrit(i)
            dp(i,j) = K1(i)*F(j);
        else
            dp(i,j) = K1_75(i)*F(j)^1.75;
        end
    end
    disp(sprintf('D %4.1f mm Umschlag von laminar auf turbulent: Flow %6.2f l/min, p_turbo/p_laminar %4.2f',...
        D(i)/mm_, Fkrit(i)/(L_/min_), Sprung(i)));
end
axes('position', [0.1 0.11 0.5 0.8]); %[left, bottom, width, height]
plot(F/lps,dp(1,:)/mbar_,'k','LineWidth',2);
hold on;
plot(F/lps,dp(2,:)/mbar_,'k--','LineWidth',2);
hold on;
plot(F/lps,dp(3,:)/mbar_,'k-.','LineWidth',2);
hold on;
plot(F/lps,dp(4,:)/mbar_,'k:','LineWidth',2);
hold on;
% es folgen die Nherungsfunktonen
plot(F/lps,dpR(1,:)/mbar_,'k','LineWidth',1);
hold on;
plot(F/lps,dpR(2,:)/mbar_,'k--','LineWidth',1);
hold on;
plot(F/lps,dpR(3,:)/mbar_,'k-.','LineWidth',1);
hold on;
plot(F/lps,dpR(4,:)/mbar_,'k:','LineWidth',1);
grid on;
xlim([0 3]);
ylim([0 100]);
title('Pressure drop \Deltap via 2 tubes and 2 breathing gas hoses');
ylabel('\Deltap / mbar');
xlabel('$\dot{\mbox{V}}$ / ($\ell$/s)','interpreter','latex');
legend('d 2.5mm, l 12cm','d 5mm, l 24cm', 'd 9mm, l 150cm', 'd 15mm, l 150cm');
axes('position', [0.66 0.11 0.3 0.8]);
plot(F(1:250)/lps,dp(1,1:250)/mbar_,'k','LineWidth',2);
hold on;
plot(F(1:250)/lps,dp(2,1:250)/mbar_,'k--','LineWidth',2);
hold on;
plot(F(1:250)/lps,dp(3,1:250)/mbar_,'k-.','LineWidth',2);
hold on;
plot(F(1:250)/lps,dp(4,1:250)/mbar_,'k:','LineWidth',2);
hold on;
% es folgen die Nherungsfunktionen in der Lupe
plot(F(1:250)/lps,dpR(1,1:250)/mbar_,'k','LineWidth',1);
hold on;
plot(F(1:250)/lps,dpR(2,1:250)/mbar_,'k--','LineWidth',1);
hold on;
plot(F(1:250)/lps,dpR(3,1:250)/mbar_,'k-.','LineWidth',1);
hold on;
plot(F(1:250)/lps,dpR(4,1:250)/mbar_,'k:','LineWidth',1);
grid on;
xlim([0 0.4]);
ylim([0 5])
xlabel('$\dot{\mbox{V}}$ / ($\ell$/s)','interpreter','latex');
title('Zoom in on the transition \newlinelaminar --> turbulent');

%------------------------------------------------
% Dsenstrmung, Ausflussfunktion
%------------------------------------------------
nfig=nfig+1;figure(nfig);clf;
p=1013*mbar_;T1=293;
dp=(1:1:1500)*mbar_;
wB=(2*dp./rho0).^0.5;
xLimit = (2/(kappa+1))^(kappa/(kappa-1));
xUnlimited = p./(p+dp);
x=max(xLimit,xUnlimited);
PSI=((kappa/(kappa-1))*(x.^(1/kappa)).*(x.^(1/kappa)-x)).^0.5;
PSI_max = (2/(kappa+1))^(1/(kappa-1))*(kappa/(kappa+1))^0.5;
w=(((1./x).^(1/kappa))./((p+dp)*rho0/(1013*mbar_))).*(p+dp).*PSI.*(2*M_luft/(R*T1))^0.5;
w2=(2*(R/M_luft)*T1*kappa/(kappa-1)*(1-x.^((kappa-1)/kappa))).^0.5;
subplot(1,2,1);
plot(dp/mbar_,w,'k',dp/mbar_,wB,'k--','LineWidth',2);
title('Outflow velocity u');
ylabel('u / (m/s)','fontweight','b');
ylim([0 500]);
xlabel('\Deltap / mbar','fontweight','b');
grid on;
%legend w wB;
subplot(1,2,2);
iEnd = 100;
plot(dp(1:iEnd)/mbar_,w(1:iEnd),'k',...
    dp(1:iEnd)/mbar_,wB(1:iEnd),'k--','LineWidth',2);
hold on;
plot(dp(1:iEnd)/mbar_,1000*(wB(1:iEnd)-w(1:iEnd))./w(1:iEnd),'k','LineWidth',1);
title('Zoom');
ylabel('u / (m/s)','fontweight','b');
xlabel('\Deltap / mbar','fontweight','b');
legend('u_{exact}', 'u_{Bernoulli}', 'rel. error/Promille');
ylim([0 140]);
grid on;
Plimit = (p/xLimit-p)/mbar_;
w_limit = max(w);
disp('----------------------');
disp('Choked flow');
disp(sprintf('Psi_max %.3f bei P_limit %.1f mbar; x_limit %.3f, u_limit %.1f m/s',...
    PSI_max, Plimit,xLimit, w_limit));

%------------------------------------------------
% Flowmessung
%------------------------------------------------
nfig=nfig+1;figure(nfig);clf;
F=(0:0.01:3);
Fend = F(end);
dp = 2;
Uend = 2;
subplot(3,1,1);
plot(F,dp*F/Fend,'k','LineWidth',2);
ylabel('\Deltap / mbar');
xlim([0 3]);
grid on;
subplot(3,1,2);
plot(F,dp*(F/Fend).^2,'k','LineWidth',2);
ylabel('\Deltap / mbar');
xlim([0 3]);
grid on;
subplot(3,1,3);
plot(F,(1.1^2+Uend^2*(F/Fend).^0.5).^0.5,'k','LineWidth',2);
xlabel('$\dot{\mbox{V}}$ / ($\ell$/s)','interpreter','latex');
ylabel('U / V');
xlim([0 3]);
grid on;
%Blendendurchmesser
% gemessen vor der Blende und in der Blende; Druckverluste vernachlssigt 
% Schlauch D1 = 15mm. Blende D2
% dp = dp2 - dp1 = 0.5*rho*(w2^2-w1^2), w=F/A, A=(pi/4)D^2.
% dp=0.5*rho*(F^2(1/((pi/4)*D2^2))^2 - 1/((pi/4)*D1^2))^2)) 
% D2 = ((4*F/pi)^0.5)*(0.5*rho/dp2)^0.25
lps = L_/s_;
D1 = 15*mm_;
dp1 = 0.5*rho0*(Fend*lps/((pi/4)*D1^2))^2;
D2_mm = (((4*Fend*lps/pi)^0.5)*(0.5*rho0/(dp*mbar_+dp1))^0.25)/mm_;
disp('-----------');
disp('Flowmessung');
disp(sprintf('Blende im 15mm-Schlauch, Flow %6.2f l/min, dp %.2f mbar, D %6.2f mm, vereinfacht nach Bernoulli',...
    Fend*lps/(L_/min_), dp, D2_mm));
% das Gleiche nach Fiedler S. 74
% gemessen unmittelbar vor und hinter der Blende
% Glg. (3.53) F = eps * C * E * D2^2 * (pi/4) * (2*dp/rho)^0.5
% mit eps = Expansionszahl zu 1 angenommen, 
% C coefficient of discharge = 0.6 geschtzt (3.55)
% E = 1 / (1 - (D2 / D1)^4)^0.5 Zulaufgeschwindigkeitsfaktor
% mit a = D1^4*(C/F)*(pi/4)*(2*dp/rho)^0.5 folgt per quadrat. Glg.
% (D2^2)_1/2 = -a/2 +-(a^2/4 + D1^4)^0.5
% nur die Lsung mit + ist zu gebrauchen
a = (D1^4)*(0.6/(Fend*lps))*(pi/4)*(2*dp*mbar_/rho0)^0.5;
D2 = (-a/2 + (a^2/4 + D1^4)^0.5)^0.5;
D2_mm = D2/mm_;
disp(sprintf('Blende im 15mm-Schlauch, Flow %6.2f l/min, dp %.2f mbar, D %6.2f mm, nach Fiedler',...
    Fend*lps/(L_/min_), dp, D2_mm));

%------------------------------------------------
% Anti-Alias Filter
%------------------------------------------------
nfig=nfig+1;figure(nfig);clf;
bessel = 0;
if bessel
    s0=15*2*pi;
    GFilter=1/(1+s/s0+(2/5)*(s/s0)^2+(1/15)*(s/s0)^3);
else
    % butterworth
    s0 = 22*2*pi;
    GFilter=1/((s/s0+1)*((s/s0)^2+s/s0+1));
end
w = omega; f = freq;
[mag,phase,w] = bode(GFilter,w);
[y,t]=step(GFilter);
ax=axes('position', [0.1 0.55 0.6 0.38]); %[left, bottom, width, height]
for i=1:M; ma(i)=mag(1,1,i); end
magdb=20*log10(ma);
semilogx(f,magdb, 'k','LineWidth',2); grid on; 
ax.GridLineStyle      = '-'; ax.GridAlphaMode      = 'manual'; ax.GridAlpha      = 0.5;
ax.MinorGridLineStyle = ':'; ax.MinorGridAlphaMode = 'manual'; ax.MinorGridAlpha = 0.9;
xlim([0.1 1000]);
title('Bode plot of the anti-alias filter');
text(0.15, -40,'$ G_{Filter}= \frac{1}{(s \cdot T_4 + 1) \cdot  \left(  (s \cdot T_4)^2 + s \cdot T_4 + 1 \right)} $',...
'Interpreter','latex','fontsize',16,'backgroundcolor', 'w');
text(0.15, -50,'$T_4 = 1 / (2 \pi \cdot 22 \mbox{Hz) = 7,2 ms } $',...
'Interpreter','latex','fontsize',11,'backgroundcolor', 'w');
ylabel('|G| / dB');
ylim([-60 10]);
ax=axes('position', [0.1 0.11 0.6 0.38]);
for i=1:M; ph(i)=phase(1,1,i); end
semilogx(f,ph, 'k','LineWidth',2); grid on;
ax.GridLineStyle      = '-'; ax.GridAlphaMode      = 'manual'; ax.GridAlpha      = 0.5;
ax.MinorGridLineStyle = ':'; ax.MinorGridAlphaMode = 'manual'; ax.MinorGridAlpha = 0.9;
xlabel('Frequency f / Hz');
xlim([0.1 1000]);
ylabel('Phase / Deg','LineWidth',2);
set(gca,'YTick',[-270 -180 -90 0]);
%text(0,0,' G_{Filter}= \frac{1}{(s \cdot T_4 + 1) \cdot  \left(  (s \cdot T_4)^2 + s \cdot T_4 + 1 \right)} \\ \\ T_4 &= 1 / (2 \pi \cdot 22 \mbox{Hz) = 7,2 ms}\\ \end{align*}',...
%'Interpreter','latex');
ax = axes('position', [0.78 0.11 0.2 0.82]);
plot(t,y, 'k','LineWidth',2); grid on;
title('Step response');
xlabel('t / s');
xlim([0 0.08]);
set(gca,'XTick',[0 0.02 0.06]);
ax.GridLineStyle = '-'; ax.GridAlphaMode = 'manual'; ax.GridAlpha = 0.5;

%------------------------------------------------
% Bode Plot Regler + Schlauch + Patient
%------------------------------------------------
s0 = 22*2*pi; % Grenzfrequenz Anti-Alias Filter
K_p = 0.04 * (L_/s_)/mbar_; % Regelungsverstrkung
%K_p = 1*(L_/s_)/mbar_;
T_I = 30*ms_; % Nachstellzeit des Integrators
R_P = 5*mbar_/(L_/s_);
C_P = 100*mL_/mbar_;
T_P = R_P*C_P;% Patientenzeitkonstante
C_S = 1.*mL_/mbar_; % Schlauchcompliance
T_RS = C_S/K_p; % Fllzeit der Schlauchcompliance
T_PS = R_P*C_S;
f=freq;
%---
GFilter=1/((s/s0+1)*((s/s0)^2+s/s0+1)); % Anti-Alias Filter
[magFilter,phaseFilter]=bode(GFilter,omega);
for i=1:M; maFilter(i)=magFilter(1,1,i); phFilter(i)=phaseFilter(1,1,i); end; 
magdbFilter=20*log10(maFilter);
%---
G_RegStrP_ohnePatient = K_p/(s*C_S);
G_geschlossenP_ohnePatient = G_RegStrP_ohnePatient/(1 + GFilter*G_RegStrP_ohnePatient);
%---
G_RegStrP = K_p/(s*C_S + 1/(R_P+1/(s*C_P))); %= K_p*Impedanz vom System: Schlauch+Patient
[magRegStrP,phaseRegStrP]=bode(G_RegStrP,omega);
for i=1:M; maRegStrP(i)=magRegStrP(1,1,i); phRegStrP(i)=phaseRegStrP(1,1,i);end; 
magdbRegStrP=20*log10(maRegStrP);
%---
G_geschlossenP = G_RegStrP / (1 + GFilter*G_RegStrP);
[magGeschlossenP,phaseGeschlossenP]=bode(G_geschlossenP,omega);
for i=1:M; maGeschlossenP(i)=magGeschlossenP(1,1,i); phGeschlossenP(i)=phaseGeschlossenP(1,1,i);end; 
magdbGeschlossenP=20*log10(maGeschlossenP);
%---
G_PI = 1 + 1/(T_I*s); %normierter PI-Regler
[magPI,phasePI]=bode(G_PI,omega);
for i=1:M; maPI(i)=magPI(1,1,i); phPI(i)=phasePI(1,1,i);end; 
magdbPI=20*log10(maPI);
%---
G_RegStrPI = G_PI * G_RegStrP;
G_geschlossenPI = G_RegStrPI / (1 + GFilter*G_RegStrPI);
[magGeschlossenPI,phaseGeschlossenPI]=bode(G_geschlossenPI,omega);
for i=1:M; maGeschlossenPI(i)=magGeschlossenPI(1,1,i); phGeschlossenPI(i)=phaseGeschlossenPI(1,1,i);end; 
magdbGeschlossenPI=20*log10(maGeschlossenPI);
%---

nfig=nfig+1;figure(nfig);clf;
ax = axes('position', [0.1 0.55 0.6 0.38]); %[left, bottom, width, height]
magdbOffenP = magdbFilter+magdbRegStrP;
magdbOffenPI = magdbFilter+magdbRegStrP+magdbPI;
semilogx(f,magdbOffenP, 'k','LineWidth',1); 
grid on; hold on;
semilogx(f,magdbPI, 'k--','LineWidth',1);
semilogx(f,magdbOffenPI, 'k--','LineWidth',2);
semilogx(f,magdbGeschlossenPI,'k','LineWidth',2); 
ax.GridLineStyle      = '-'; ax.GridAlphaMode      = 'manual'; ax.GridAlpha      = 0.5;
ax.MinorGridLineStyle = ':'; ax.MinorGridAlphaMode = 'manual'; ax.MinorGridAlpha = 0.9;
xlim([0.1 1000]);
text(0, 1.06,'Bode plots of system parts','units','normalized','fontweight','b');
ylabel('|G| / dB');
legend('G_{openP}', 'G_{PI}', 'G_{openPI}','G_{closedPI}',...
    'Location','NorthEast');
ylim([-40 30]);

ax = axes('position', [0.1 0.11 0.6 0.38]);
phOffenP = phFilter+phRegStrP;
phOffenPI = phFilter+phRegStrP+phPI;
semilogx(f,phOffenP,'k','LineWidth',1);
grid on; hold on;
semilogx(f,phPI,'k--','LineWidth',1);
semilogx(f,phOffenPI,'k--','LineWidth',2);
semilogx(f,phGeschlossenPI,'k','LineWidth',2); 
xlabel('Frequency f / Hz');
xlim([0.1 1000]);
ylim([-270 90]);
ylabel('Phase / Deg');
set(gca,'YTick',[-270 -180 -90 0]);
ax.GridLineStyle      = '-'; ax.GridAlphaMode      = 'manual'; ax.GridAlpha      = 0.5;
ax.MinorGridLineStyle = ':'; ax.MinorGridAlphaMode = 'manual'; ax.MinorGridAlpha = 0.9;

axes('position', [0.78 0.11 0.2 0.82]);
[y,t]=step(G_geschlossenPI);
plot(t,y,'k','LineWidth',2);hold on;
[y,t]=step(G_geschlossenP_ohnePatient,t);
plot(t,y,'k','LineWidth',1);
[y,t]=step(G_geschlossenP,t);
plot(t,y,'k--','LineWidth',1);
xlim([0 2]); ylim([0 1.4]);
text(0,1.03,'Step responses','units','normalized','fontweight','b');
legend('PI + pat.','P w/o pat.','P + pat.');
xlabel('t / s');
grid on;
%---
c2d(1/(1+0.03*s),0.01);

%------------------------------------------------
% Straufschaltung Gs = Paw/Pmus
%------------------------------------------------
Twait=0.1; Ti=1; Te=1.4;
t =0:0.001:Twait+Ti+Te;
len=length(t);
Pmus=zeros(len,1);
Pstep=ones(len,1);
for i=1:len
    if t(i) < Twait
        Pstep(i)=0;
    end
end
Pstep = lsim(1/(1+50*ms_*s),Pstep,t); % Fhrungsfilter 50ms
Pmus0 = 1;
i0 = cast(cast(len,'double')*Twait/t(end),'int32')+1;
for i=i0:len
    tb = t(i)-Twait;
    Pmus(i)= -Pmus0 * (1-exp(-5*tb/Ti)) / (1-exp(-5));
end
Gs = 1/(1+(R_P+1/(s*C_P))*(s*C_S+GFilter*G_PI*K_p));
grid on;

%------------------------------------------------
% Atemhub = Fhrungsverhalten, Atemzug = Strverhalten
%------------------------------------------------
% 2 Reihen a 4 Kurven.
% 1. Reihe Fhrungsverhalten Sprungfunktion
% 2. Reihe Straufschaltung Muskeldruck
% Spalten: 1) nur Schlauch, K_p=0.04, 2) Patient R=5 C=100 K_p=0.08
%          3) R=20,C=10,K_p = 0.08    4) R=5, C=100, K_p=0.2
P = ones(len,8);
%---1
K_p=0.04*(L_/s_)/mbar_;
Gsys = (1+1/(T_I*s))*K_p/(s*C_S) ...
      /(1 + GFilter*(1+1/(T_I*s))*K_p/(s*C_S));
y=lsim(Gsys,Pstep,t);
P(:,1)=y;
% Gstoer geht hier nicht (ohne Patient kein Muskeldruck mglich)
%---2
K_p=0.08*(L_/s_)/mbar_; R_P=5*mbar_/(L_/s_);C_P=100*mL_/mbar_;
Gsys = (1+1/(T_I*s))*K_p/(s*C_S + 1/(R_P+1/(s*C_P))) ...
      /(1 + GFilter*(1+1/(T_I*s))*K_p/(s*C_S + 1/(R_P+1/(s*C_P))));
y=lsim(Gsys,Pstep,t);
P(:,2)=y;
Gstoer=1/(1+(R_P+1/(s*C_P))*(s*C_S+GFilter*G_PI*K_p));
y=lsim(Gstoer,Pmus,t);
P(:,2+4)=y;
%---3
K_p=0.08*(L_/s_)/mbar_; R_P=20*mbar_/(L_/s_);C_P=10*mL_/mbar_;
Gsys = (1+1/(T_I*s))*K_p/(s*C_S + 1/(R_P+1/(s*C_P))) ...
      /(1 + GFilter*(1+1/(T_I*s))*K_p/(s*C_S + 1/(R_P+1/(s*C_P))));
y=lsim(Gsys,Pstep,t);
P(:,3)=y;
Gstoer=1/(1+(R_P+1/(s*C_P))*(s*C_S+GFilter*G_PI*K_p));
y=lsim(Gstoer,Pmus,t);
P(:,3+4)=y;
%-- marker
tm=0:0.3:Twait+Ti+Te;
j=1;
p1=[];p2=[];tt=tm(j);
for i=1:length(t)
    if t(i) >= tt
        p1(j) = P(i,3);
        p2(j) = P(i,3+4);
        j=j+1;
        if j > length(tm)
            break;
        end
        tt = tm(j);
    end
end
%---4
K_p=0.2*(L_/s_)/mbar_; R_P=5*mbar_/(L_/s_);C_P=100*mL_/mbar_;
Gsys = (1+1/(T_I*s))*K_p/(s*C_S + 1/(R_P+1/(s*C_P))) ...
      /(1 + GFilter*(1+1/(T_I*s))*K_p/(s*C_S + 1/(R_P+1/(s*C_P))));
y=lsim(Gsys,Pstep,t);
P(:,4)=y;
Gstoer=1/(1+(R_P+1/(s*C_P))*(s*C_S+GFilter*G_PI*K_p));
y=lsim(Gstoer,Pmus,t);
P(:,4+4)=y;
%---plot
nfig=nfig+1;figure(nfig);clf;
axes('position', [0.083 0.12 0.4 0.8]); %[left, bottom, width, height]
plot(t,Pstep, 'k','LineWidth',3); hold on;
plot(t,P(:,1),'k','LineWidth',1); hold on;
plot(t,P(:,2),'k--','LineWidth',2); hold on;
plot(tm,p1,'kd','LineWidth',2);hold on;
plot(t,P(:,4),'k--','LineWidth',3); hold on;
plot(t,P(:,3),'k','LineWidth',2); hold on;
grid on;
title('Respiratory stroke = control response');
ylabel('Paw / Pset_0','fontweight','b'); xlabel('t / s');
ylim([0.8 1.201]);
legend('Pset or Pmus','K_p 0.04, no patient','K_p 0.08, R 5, C 0.1', 'K_p 0.08, R 20, C 0.01',...
    'K_p 0.2, R 5, C 0.1', 'Location','Best');
axes('position', [0.581 0.12 0.4 0.8]);
plot(t,Pmus,  'k','LineWidth',3); hold on;
plot(t,P(:,2+4),'k--','LineWidth',2); hold on;
plot(tm,p2,'kd','LineWidth',2);hold on;
plot(t,P(:,4+4),'k--','LineWidth',3);hold on;
plot(t,P(:,3+4),'k','LineWidth',2); hold on;
grid on;
title('Breath = disturbance response');
ylabel('Paw / Pmus_0','fontweight','b'); xlabel('t / s');
ylim([-0.2 0.2]);
end  %+++++++++++++++++++++++++++++++++++++++++++++++++Abkrzung 1 Ende

if 1  %+++++++++++++++++++++++++++++++++++++++++++++++++Abkrzung 2

end  %+++++++++++++++++++++++++++++++++++++++++++++++++Abkrzung 2 Ende

if 1  %+++++++++++++++++++++++++++++++++++++++++++++++++Abkrzung 3

%------------------------------------------------
% Exspirationsventil rechnen
%------------------------------------------------
mA_=0.001; T_ = 1; cm_=0.01;
P=5*mbar_;D=30*mm_; A=(pi/4)*D^2; F = P*A;
V=10*mA_/mbar_;B=0.4*T_;I = P*V; L_F = F/(B*I); n=L_F/(pi*D);
Flow = 60*L_/min_; s = (Flow/(pi*D))*(rho0/(2*P))^0.5;
disp('------------------');
disp('Exspirationsventil');
disp(sprintf('P 5mbar, D %5.2f mm, A %5.2f qmm, F %5.2f N, B 0.4T,\nI %5.2f mA, L_F %5.2f cm, n %4.0f',...
D/mm_,A/(mm_)^2, F, I/mA_, L_F/cm_, n));
fprintf('Flow 60L/min, s%5.2f mm\n',s/mm_);
%------------------------------------------------
% Kingsches Gesetz
%------------------------------------------------
% Nu = 0.42 *Pr^0.2 + 0.57*Pr^0.33 * Re^0.5
% I^2*R = Nu*pi*lambda*l*DeltaT
% Pr = cp*eta/lambda = 4*kappa/(9*kappa-5)
% kappa = 1.4
% Re = w*D*rho/eta
% I^2*R = l*DeltaT*((pi*0.42*Pr^0.2)*lambda + 0.57*Pr^(-0.17)*(pi^2*lambda^2*Pr*Re)^0.5
% Term unter der Wurzel = pi^2*lambda^2*(cp*eta/lambda)*(D*rho/eta)*w
%                       = pi^2*lambda*cp*D*rho*w
% I^2*R = l*DeltaT*(pi*0.42*Pr^0.2)*lambda + 0.57*Pr^(-0.17)*pi^0.5*(pi*lambda*cp*rho*D*w)^0.5
% zu schreiben als
% I^2*R = l*DeltaT*(a*lambda + b*(lambda*cp*rho*pi*D*w)^0.5
kappa = 1.4;
Pr    = 4*kappa/(9*kappa-5);
a     = pi*0.42*Pr^0.2;
b     = 0.57*Pr^(-0.17)*pi^0.5;
disp('----------------');
disp('Kingsches Gesetz');
fprintf('kappa %5.2f, Pr %5.2f, a %5.2f, b %5.2f\n',kappa, Pr, a, b);
%---
% cp = cp_spezifisch = Cp_mol / M_mol
% cp * rho = Cp_mol/M_mol* M_mol/V_mol = Cp_mol/V_mol
% Cp = a + b * (theta/1000) + c*(theta/1000)^2
% Wikipedia 'Tabellensammlung Chemie/ spezifische Wrmekapazitten'
% Sauerstoff a 27.96, b 4.180, c-0.1670
% Stickstoff a 28.30, b 2.537, c 0.5443
T = 273:1273; theta=T-273;
Cp_O2 = 27.96 + 4.180*T/1000 -0.1670*(T/1000).^2;
Cp_N2 = 28.30 + 2.537*T/1000 +0.5443*(T/1000).^2;
nfig=nfig+1;figure(nfig);clf;
plot(theta,Cp_O2, theta,Cp_N2); grid on;
title('Temperaturabhngigkeit der Wrmekapazitt bei konstantem Druck');
xlabel('\theta / C'); ylabel('Cp / (J/(mol*K))');
legend('Cp_{O2}', 'Cp_{N2}');
%--- lambda = (0.02427 + 7.130*1E-5*theta) W/(m*K)
nfig=nfig+1;figure(nfig);clf;
lambda_1 = 0.02427+7.130E-5*theta;
lambda_2 = 0.02427*(T/273).^0.5;
plot(theta,lambda_1,theta,lambda_2); grid on;
title('Temperaturabhngigkeit der Wrmeleitfhigkeit');
xlabel('\theta / C'); ylabel('\lambda / (W/(m*K))');
legend('\lambda_{O2}', '\lambda_{N2}');

end   %+++++++++++++++++++++++++++++++++++++++++++++++++Abkrzung 3 Ende


