function plotRegulatorModel
logsout   = evalin('base','RegulatorLogsout');
t         = logsout.getElement('Paw').Values.Time;
Paw       = logsout.getElement('Paw').Values.Data;
Ptrach    = logsout.getElement('Ptrach').Values.Data;
Fpat      = logsout.getElement('Fpat').Values.Data;
Pmus      = logsout.getElement('Pmus').Values.Data;
Palv      = logsout.getElement('Palv').Values.Data;
Volume    = logsout.getElement('Volume').Values.Data;
SequenzNr = cast(logsout.getElement('SequenceNo').Values.Data(1), 'double');
yP = [-5,15]; yF = [-1, 1];
sec = 10000;
if SequenzNr == 1 % CMV, AC
    i1 = cast(6*sec,'uint32');
    i2 = cast(36*sec,'uint32');
    t_ = t(1:i2-i1+1);
    tNull = [t_(1) t_(end)];
    yNull = [0 0];
    V = Volume(i1:i2)-min(Volume(i1:i2));
    figure(SequenzNr); clf;
    axes('position', [0.1 0.52 0.85 0.40]); %[left, bottom, width, height]
    plot(t_,Paw(i1:i2),'k','LineWidth',3);
    hold on;
    plot(t_,Palv(i1:i2),'k','LineWidth',1);
    hold on;
    plot(t_,Pmus(i1:i2),'k','LineWidth',2);
    hold on;
    plot(tNull,yNull,'--k','LineWidth',2);
    grid on;
    ylim(yP);
    title('Ventilator f = 12/min, CMV VC then AC PC with f_{spon} = 15/min');
    legend('p_{aw}','p_{alv}','p_{mus}');
    ylabel('mbar');
    axes('position', [0.1 0.06 0.85 0.40]); %[left, bottom, width, height]
    plot(t_,Fpat(i1:i2),'k','LineWidth',2);
    hold on;
    plot(t_,V,'k','LineWidth',1);
    hold on;
    plot(tNull,yNull,'--k','LineWidth',2);
    grid on;
    legend({'$\dot{\mbox{V}}$ / ($\ell$/s)','V / $\ell$'},'Interpreter','latex',...
        'Location','SouthWest');
    ylim(yF);
end
if SequenzNr == 2 % SIMV
    figure(SequenzNr); clf;
    pruef_tick = 12*[ 1 1 1 1];
    t_tick = 10*[ 1 2 3 4] + 1.5 - 8;
    i1 = cast(8*sec,'uint32');
    i2 = cast(43*sec,'uint32');
    t_ = t(1:i2-i1+1);
    tNull = [t_(1) t_(end)];
    yNull = [0 0];
    V = Volume(i1:i2)-min(Volume(i1:i2));
    axes('position', [0.1 0.52 0.85 0.40]); %[left, bottom, width, height]
    plot(t_,Paw(i1:i2),'k','LineWidth',3);
    hold on;
    plot(t_,Palv(i1:i2),'k','LineWidth',1);
    hold on;
    plot(t_,Pmus(i1:i2),'k','LineWidth',2);
    hold on;
    for i=1:length(t_tick)
        plot(sort([t_tick(i) t_tick(i)+5]), [pruef_tick(i) pruef_tick(i)], 'k-.');%'kd');
    end
    xlim([0 t_(end)]);
    hold on;
    plot(tNull,yNull,'--k','LineWidth',1);
    grid on;
    ylim(yP);
    title('SIMV PC, Ventilator f = 6/min, f_{spon} = 15/min');
    legend('p_{aw}','p_{alv}','p_{mus}','trig.window');
    ylabel('mbar');
    axes('position', [0.1 0.06 0.85 0.40]); %[left, bottom, width, height]
    plot(t_,Fpat(i1:i2),'k','LineWidth',2);
    hold on;
    plot(t_,V,'k','LineWidth',1);
    hold on;
    plot(tNull,yNull,'--k','LineWidth',2);
    grid on;
    legend({'$\dot{\mbox{V}}$ / ($\ell$/s)','V / $\ell$'},'Interpreter','latex',...
        'Location','SouthWest');
    ylim(yF);
end
if SequenzNr == 3 % CPAP: ohne Untersttzung, PS, ATC, PPS
    figure(SequenzNr); clf;
    i1 = cast(5*sec,'uint32');
    i2 = cast(45*sec,'uint32');
    t_ = t(1:i2-i1+1);
    tNull = [t_(1) t_(end)];
    yNull = [0 0];
    V = Volume(i1:i2)-min(Volume(i1:i2));
    axes('position', [0.1 0.42 0.85 0.50]); %[left, bottom, width, height]
    plot(t_,Paw(i1:i2),'k','LineWidth',3);
    hold on;
    plot(t_,Ptrach(i1:i2),':k','LineWidth',2);
    hold on;
    plot(t_,Palv(i1:i2),'k','LineWidth',1);
    hold on;
    plot(t_,Pmus(i1:i2),'k','LineWidth',2);
    hold on;
    plot(tNull,yNull,'--k','LineWidth',2);
    grid on;
    ylim([-4,12]);
    title('Traces of  CPAP,  CPAP/PS,   CPAP/ATC  and  CPAP/PPS');
    ylabel('mbar');
    tb = 8.5; lo=1; hi=2.5; yt = 1.4;
    plot([tb,tb],[lo,hi],'k','LineWidth',2); text(tb-5, yt, 'CPAP');
    tb = tb+8; plot([tb,tb],[lo,hi],'k','LineWidth',2); text(tb-6, yt, 'CPAP/PS');
    tb = tb+12; plot([tb,tb],[lo,hi],'k','LineWidth',2);  text(tb-8, yt, 'CPAP/ATC');
    legend('p_{aw}','p_{trach}','p_{alv}','p_{mus}','Location','NorthEast');
    text(tb+3, yt, 'CPAP/PPS');
    tb = 0.195; %0.365;%0.195;
    annotation('textarrow',[tb-0.00,tb],[0.87,0.76],'String','p_i');
    annotation('textarrow',[tb,tb],[0.10,0.14],'String','endexp. Flow');
        %'$\dot{\mbox{V}}_{ee}$','Interpreter','latex');
    axes('position', [0.1 0.06 0.85 0.30]); %[left, bottom, width, height]
    plot(t_,Fpat(i1:i2),'k','LineWidth',2);
    hold on;
    plot(t_,V,'k','LineWidth',1);
    hold on;
    plot(tNull,yNull,'--k','LineWidth',2);
    grid on;
    legend({'$\dot{\mbox{V}}$ / ($\ell$/s)','V / $\ell$'},'Interpreter','latex',...
        'Location','SouthEast');
end
if SequenzNr == 4 % Vergleichsbild Volumen-/Druckkontrolliert und Pat RC
    i1 = cast(10.5*sec,'uint32');
    i2 = cast(30.5*sec,'uint32');
    t_ = t(1:i2-i1+1);
    tNull = [t_(1) t_(end)];
    yNull = [0 0];
    V = Volume(i1:i2)-min(Volume(i1:i2));
    figure(SequenzNr); clf;    
    subplot(3,1,1);
    plot(t_,Paw(i1:i2),'k','LineWidth',2);
    title('Volume versus pressure controlled ventilation, 2 strokes each');
    ylim([0 15]);
    grid on;
    ylabel('p_{aw} / mbar');
    subplot(3,1,2);
    plot(t_,Fpat(i1:i2),'k','LineWidth',2);
    ylim([-1.2 1.2]);
    grid on;
    ylabel('$\dot{\mbox{V}}$ / ($\ell$/s)','Interpreter','latex','fontweight','b');
    subplot(3,1,3);
    plot(t_,Volume(i1:i2),'k','LineWidth',2);
    ylim([0 1.2]);
    grid on;
    ylabel('V / $\ell$','Interpreter','latex','fontweight','b');
    xlabel('t / s');
    %---
    figure(11);clf
    subplot(3,1,1);
    i2 = cast(20.5*sec,'uint32');
    t_ = t(1:i2-i1+1);
    plot(t_,Paw(i1:i2),'k','LineWidth',2);
    ylim([0 15]);
    grid on;
    ylabel('p_{aw} / mbar');
    subplot(3,1,2);
    plot(t_,Fpat(i1:i2),'k','LineWidth',2);
    ylim([-1.2 1.2]);
    grid on;
    ylabel('$\dot{\mbox{V}}$ / ($\ell$/s)','Interpreter','latex','fontweight','b');
    text(1.7,1.5,'$\dot{\mbox{V}}_i$','Interpreter','latex');
    subplot(3,1,3);
    plot(t_,Volume(i1:i2),'k','LineWidth',2);
    ylim([0 1.2]);
    grid on;
    ylabel('V / $\ell$','Interpreter','latex','fontweight','b');
    text(0.6,1,'V_T');
    xlabel('t / s');
    o=-0.105;
    annotation('textarrow',[0.325+o,0.375+o],[0.288,0.288]);
    annotation('textarrow',[0.38+o,0.38+o],[0.63,0.57]);
    annotation('textarrow',[0.3+o,0.3+o],[0.86,0.785],'String','PEEP');
    annotation('textarrow',[0.387+o,0.387+o],[0.94,0.886],'String','PIP');
    annotation('textarrow',[0.45+o,0.45+o],[0.93,0.86],'String','EIP');
    annotation('textarrow',[0.48+o,0.48+o],[0.87,0.8],'String','2');
    annotation('textarrow',[0.6+o,0.6+o],[0.86,0.785],'String','3');
end